; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_act_pos' (global) is 102
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_start_delay' (global) is 111
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_bridge_switch1' (global) is 113
;       The value of 'mem_bridge_switch2' (global) is 114
;       The value of 'mem_bridge_switch3' (global) is 115
;       The value of 'mem_bridge_switch4' (global) is 116
;       The value of 'mem_bridge_switch5' (global) is 117
;       The value of 'mem_bridge_switch6' (global) is 118
;       The address of 'value' (byte) (global) is 0x30
	value EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x31
	act_pos EQU 0x31
;       The address of 'max_pos' (byte) (global) is 0x32
	max_pos EQU 0x32
;       The address of 'steps' (word) (global) is 0x33
	steps EQU 0x33
;       The address of 'value2' (byte) (global) is 0x35
	value2 EQU 0x35
;       The address of 'new_steps' (word) (global) is 0x36
	new_steps EQU 0x36
;       The address of 'ctrl_type' (byte) (global) is 0x38
	ctrl_type EQU 0x38
;       The address of 'manual_pos' (byte) (global) is 0x39
	manual_pos EQU 0x39
;       The address of 'free_space_steps' (byte) (global) is 0x3A
	free_space_steps EQU 0x3A
;       The address of 'bridge_switch' (bit) (global) is 0x3B,0
;       The address of 'speed_min' (word) (global) is 0x3C
	speed_min EQU 0x3C
;       The address of 'result' (byte) (global) is 0x3E
	result EQU 0x3E
;       The address of 'speed_max' (word) (global) is 0x3F
	speed_max EQU 0x3F
;       The address of 'program_set' (byte) (global) is 0x41
	program_set EQU 0x41
;       The address of 'one_round' (word) (global) is 0x42
	one_round EQU 0x42
;       The address of 'start_delay' (byte) (global) is 0x44
	start_delay EQU 0x44
;       The address of 'use_zero_detector' (byte) (global) is 0x45
	use_zero_detector EQU 0x45
;       The address of 'act_steps' (word) (global) is 0x46
	act_steps EQU 0x46
;       The address of 'turn_counter' (byte) (global) is 0x48
	turn_counter EQU 0x48
;       The address of 'speed_step' (byte) (global) is 0x49
	speed_step EQU 0x49
;       The address of 'new_pos' (byte) (global) is 0x4A
	new_pos EQU 0x4A
;       The address of 'version' (bit) (global) is 0x3B,1
;       The address of 'bus_pos' (byte) (global) is 0x4B
	bus_pos EQU 0x4B
;       The address of 'free_space_word' (word) (global) is 0x4C
	free_space_word EQU 0x4C
;       The address of 'disp1_val' (byte) (global) is 0x4E
	disp1_val EQU 0x4E
;       The address of 'speed' (word) (global) is 0x4F
	speed EQU 0x4F
;       The address of 'new_encoder' (byte) (global) is 0x51
	new_encoder EQU 0x51
;       The address of 'encoder_count' (byte) (global) is 0x52
	encoder_count EQU 0x52
;       The address of 'disp2_val' (byte) (global) is 0x53
	disp2_val EQU 0x53
;       The address of 'bridge_power' (bit) (global) is 0x3B,2
;       The address of 'eprom_pointer' (byte) (global) is 0x54
	eprom_pointer EQU 0x54
;       The address of 'steps_set' (bit) (global) is 0x3B,3
;       The address of 'old_encoder' (byte) (global) is 0x55
	old_encoder EQU 0x55
;       The address of 'old_manual_pos' (byte) (global) is 0x56
	old_manual_pos EQU 0x56
;       The address of 'ramp_up' (bit) (global) is 0x3B,4
;       The address of 'ramp_down_point' (word) (global) is 0x57
	ramp_down_point EQU 0x57
;       The address of 'one_round_half' (word) (global) is 0x59
	one_round_half EQU 0x59
;       The address of 'old_bus_pos' (byte) (global) is 0x5B
	old_bus_pos EQU 0x5B
;       The address of 'old_bridge_switch' (bit) (global) is 0x3B,5
;       The address of 'old_pos_write' (bit) (global) is 0x3B,6
;       The address of 'start_delay_wait' (word) (global) is 0x5C
	start_delay_wait EQU 0x5C
;       The address of 'half_steps' (word) (global) is 0x5E
	half_steps EQU 0x5E
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
;       The address of 'fy_stop' (bit) (global) is 0x5,5
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,3
	GOTO L0022
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111, %11000000)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
	RETLW 0xC0
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0022:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: 'V3.7 extra separate positions for FY and TT with contact sliders.
; 9: '-----MGV50 input changed, ramp-up and ramp-down activated, including separate settings for min and max speed
; 10: 'V4.1 inital setting for FY, set pos 1 and pos 2 correct, rest will be automatic.
; 11: 'V4.4 initial setting freespace dafaults to 0.
; 12: '-    positions 0 and 63 are allowed from I/O input >>>> 63 will be seen as 0
; 13: '-    manual position setting can be turned through zero
; 14: 'V4.5 extra menu 8 for setting the first position where rail power should be reversed
; 15: 'V4.6 0 point will also control cable twist
; 16: 'V4.7 Fiddle yard (ctrl type 6) has only 5 selection lines.(max 30 positions , 31 = zero adjust)
; 17: '-    pos.req 6 is set as input, MGV50 should be set as block output
; 18: '-    the two connection rails in and out are connected to current detection
; 19: '-    any train on these tracks will give siganl,where FY will stop immediately (same as endswitch)
; 20: 'V4.8 Extra menu added for settings of reverse/not per position (only for 0,2,4 )
; 21: '-    These bits (bridge_switch) are stored and read in 6 bytes
; 22: 'V4.9 Free_space_steps multiplied by 10 , 990 correction steps available
; 23: '-    Positions are changed to 0-47
; 24: '-    Maximum positons can be as low as two
; 25: 'V5.0 Correction for init eprom routine position change to 0-47
; 26: '-    Free_space_steps multiplier changed to 4
; 27: '-    Added position 62 for recalibration, turn in direction 0 until 0 detector reached and set position to 0
; 28: '-    Added menu option 9 to operate the stepper motor without changing the stored steps
; 29: 'V5.1 Correction for bug that when a position is at 0 steps (perfectly aligned zero detector)
; 30: '-    the "determine one round" routine is called when selecting that position
; 31: 'V5.2 Correction for relay control, only switch relays before and after moving, only when needed
; 32: '-    Menu 0 and 1 only available when posistion is a real position, not a special position (62, 63)
; 33: 'V5.3 Read bridge_power setting during initialisation
; 34: 'V5.4 Added option via menu 9 to use zero position detector to go to position 0, removed manual operation via menu 9
; 35: '-    When running clockwise (from high to low position) to position 0 run until zero detector signals
; 36: '-    when running counter clockwise run until zero detector goes back off again and then
; 37: '-    run in other direction until zero detector signals again. Show the number of stepds needed to reach zero
; 38: '-    detector again and store that as free_space_steps.
; 39: '-    added position 61 which is the same As position 62 but Then in other direction, run past zero detector,"
; 40: '-    run backwards until zero detector signals and store number of steps needed as free_space_steps
; 41: 'V5.5 Changed menu 8 to set both bridge power setting, use zero position detector setting,
; 42: '-    and added option wether or not to use zero position detector to correct free space steps
; 43: '-    Added an option for a wait time in 0.1s between position match going off and start of steppermotor
; 44: '-    to allow -servo operated- bridge signals to change position, value adjustable via menu option 9.
; 45: '-    When the safety switch is activated, or in case of control tpye 6 (fiddle-yard) position indication bit 5
; 46: '-    is turned on, this emergency stop is shown on the display because it now displays start position and
; 47: '-    the left dot will blink.
; 48: Define CONF_WORD = 0x3f72
; 49: Define CLOCK_FREQUENCY = 20
; 50: 'Define SIMULATION_WAITuS_VALUE = 1
; 51: Dim steps As Word
; 52: Dim half_steps As Word
; 53: Dim ramp_down_point As Word
; 54: Dim program_set As Byte
; 55: Dim new_steps As Word
; 56: Dim act_steps As Word
; 57: Dim new_pos As Byte
; 58: Dim act_pos As Byte
; 59: Dim one_round As Word
; 60: Dim one_round_half As Word
; 61: Dim bus_pos As Byte
; 62: Dim old_bus_pos As Byte
; 63: Dim speed As Word
; 64: Dim speed_min As Word
; 65: Dim speed_max As Word
; 66: Dim new_encoder As Byte
; 67: Dim old_encoder As Byte
; 68: Dim manual_pos As Byte
; 69: Dim old_manual_pos As Byte
; 70: Dim result As Byte
; 71: Dim free_space_steps As Byte
; 72: Dim free_space_word As Word
; 73: Dim value As Byte
; 74: Dim value2 As Byte
; 75: Dim eprom_pointer As Byte
; 76: Dim encoder_count As Byte
; 77: Dim turn_counter As Byte
; 78: Dim old_bridge_switch As Bit
; 79: Dim max_pos As Byte
; 80: Dim disp1_val As Byte
; 81: Dim disp2_val As Byte
; 82: Dim ctrl_type As Byte
; 83: Dim old_pos_write As Bit
; 84: Dim ramp_up As Bit
; 85: Dim speed_step As Byte
; 86: Dim version As Bit
; 87: Dim steps_set As Bit
; 88: Dim bridge_power As Bit
; 89: Dim bridge_switch As Bit
; 90: Dim use_zero_detector As Byte
; 91: Dim start_delay As Byte
; 92: Dim start_delay_wait As Word
; 93: Const disp1 = 64
; 94: Const disp2 = 66
; 95: Const mem_turn_counter = 101
; 96: Const mem_act_pos = 102
; 97: Const mem_speed_min = 103
; 98: Const mem_speed_max = 104
; 99: Const mem_speed_step = 105
; 100: Const mem_one_round_lb = 106
; 101: Const mem_one_round_hb = 107
; 102: Const mem_ctrl_type = 108
; 103: Const mem_max_pos = 109
; 104: Const mem_free_space = 110
; 105: Const mem_start_delay = 111
; 106: Const mem_bridge_power = 112
; 107: Const mem_bridge_switch1 = 113
; 108: Const mem_bridge_switch2 = 114
; 109: Const mem_bridge_switch3 = 115
; 110: Const mem_bridge_switch4 = 116
; 111: Const mem_bridge_switch5 = 117
; 112: Const mem_bridge_switch6 = 118
; 113: Symbol swfw = RB0
; 114: Symbol swrev = RB1
; 115: Symbol sck = RB2
; 116: Symbol sda = RB3
; 117: Symbol pos_match = RB4
; 118: Symbol pos_write = RB5
; 119: Symbol eep = RB6
; 120: Symbol max_end = RB7
; 121: Symbol direction = RC0
; 122: Symbol clk = RC1
; 123: Symbol ena = RC2
; 124: Symbol zero = RC3
; 125: Symbol ec1 = RC4
; 126: Symbol ec2 = RC5
; 127: Symbol ecsw = RC6
; 128: Symbol pgm = RC7
; 129: Symbol fy_stop = RA5
; 130: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 131: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 132: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 133: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 134: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 135: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 136: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 137: value = 55  'version number
	MOVLW 0x37
	MOVWF 0x30
; 138: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 139: value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 140: version = 1
	BSF 0x3B,1
; 141: Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 142: Gosub read_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 143: old_bridge_switch = Not bridge_switch  'make sure that bridge power will be turned on
	BTFSS 0x3B,0
	BSF 0x3B,5
	BTFSC 0x3B,0
	BCF 0x3B,5
; 144: Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 145: program_set = 1
	MOVLW 0x01
	MOVWF 0x41
; 146: main:
L0001:
; 147: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0023
; 148: 		Gosub adjust_settings
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0004
; 149: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 150: 	Endif
L0023:
; 151: 
; 152: 	Gosub get_new_position
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0002
; 153: 	If bus_pos <> old_bus_pos Then
	MOVF 0x4B,W
	SUBWF 0x5B,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0024
; 154: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 155: 		If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,2
	GOTO L0025
; 156: 			swfw = 0
	BCF 0x06,0
; 157: 			swrev = 0
	BCF 0x06,1
; 158: 		Endif
L0025:
; 159: 		If start_delay > 0 Then  'give signals time to change
	MOVF 0x44,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0026
; 160: 			start_delay_wait = start_delay * 100
	MOVF 0x44,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x5C
	MOVF R2H,W
	MOVWF 0x5D
; 161: 			WaitMs start_delay_wait
	MOVF 0x5C,W
	MOVWF R0L
	MOVF 0x5D,W
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 162: 		Endif
L0026:
; 163: 		new_pos = bus_pos
	MOVF 0x4B,W
	MOVWF 0x4A
; 164: 		Gosub stepmotor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0007
; 165: 		value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 166: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 167: 		Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 168: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 169: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0027
L0024:
; 170: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0028
; 171: 			If manual_pos <> old_manual_pos Then
	MOVF 0x39,W
	SUBWF 0x56,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0029
; 172: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 173: 				If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,2
	GOTO L0030
; 174: 					swfw = 0
	BCF 0x06,0
; 175: 					swrev = 0
	BCF 0x06,1
; 176: 				Endif
L0030:
; 177: 				If start_delay > 0 Then  'give signals time to change
	MOVF 0x44,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0031
; 178: 					start_delay_wait = start_delay * 100
	MOVF 0x44,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x5C
	MOVF R2H,W
	MOVWF 0x5D
; 179: 					WaitMs start_delay_wait
	MOVF 0x5C,W
	MOVWF R0L
	MOVF 0x5D,W
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 180: 				Endif
L0031:
; 181: 				old_manual_pos = manual_pos
	MOVF 0x39,W
	MOVWF 0x56
; 182: 				new_pos = manual_pos
	MOVF 0x39,W
	MOVWF 0x4A
; 183: 				Gosub stepmotor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0007
; 184: 				value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 185: 				Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 186: 				Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 187: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 188: 			Endif
L0029:
; 189: 		Endif
L0028:
; 190: 	Endif
L0027:
; 191: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 192: 	Goto main
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0001
; 193: End
;       PAGE SELECT
;	BCF PCLATH,3
L0032:	GOTO L0032
; 194: 
; 195: get_new_position:
L0002:
; 196: 	value = bus_pos  'remember the position
	MOVF 0x4B,W
	MOVWF 0x30
; 197: 	If pos_write = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0033
; 198: 		If old_pos_write = 0 Then  'react only once on rising edge
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,6
	GOTO L0034
; 199: 			old_pos_write = 1
	BSF 0x3B,6
; 200: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x30
; 201: 			If ctrl_type = 6 Then  'fiddle yard max = 30
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0035
; 202: 				value = value And 31
	MOVF 0x30,W
	MOVWF R0L
	MOVLW 0x1F
	ANDWF R0L,W
	MOVWF 0x30
; 203: 				If value = 31 Then  '31 is for zero adjust, maybe only 5 bits are available
	MOVF 0x30,W
	SUBLW 0x1F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0036
; 204: 					value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 205: 				Endif
L0036:
; 206: 			Endif
L0035:
; 207: 			Select Case value
; 208: 			Case 63  'make zero adjust
	MOVF 0x30,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0037
; 209: 				value = 0
	CLRF 0x30
; 210: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0038
L0037:
; 211: 				If value > max_pos Then  'this is not allowed
	MOVF 0x30,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0039
; 212: 					value = bus_pos  'put it back to old situation
	MOVF 0x4B,W
	MOVWF 0x30
; 213: 				Endif
L0039:
; 214: 			EndSelect
L0038:
; 215: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 216: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x30,W
	SUBWF 0x4B,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0040
; 217: 				pos_match = 1
	BSF 0x06,4
; 218: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 219: 				pos_match = 0
	BCF 0x06,4
; 220: 			Endif
L0040:
; 221: 		Endif
L0034:
; 222: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0041
L0033:
; 223: 		old_pos_write = 0
	BCF 0x3B,6
; 224: 	Endif
L0041:
; 225: 	bus_pos = value  'now take over the desired position
	MOVF 0x30,W
	MOVWF 0x4B
; 226: 	Gosub calc_rotation
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0003
; 227: 	Select Case result
; 228: 	Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 229: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x52,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0043
; 230: 			encoder_count = encoder_count + 1
	MOVF 0x52,W
	ADDLW 0x01
	MOVWF 0x52
; 231: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0044
L0043:
; 232: 			encoder_count = 0
	CLRF 0x52
; 233: 			Select Case manual_pos
; 234: 			Case 63
	MOVF 0x39,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0045
; 235: 				manual_pos = 0
	CLRF 0x39
; 236: 			Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0046
L0045:
	MOVF 0x39,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0047
; 237: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x39
; 238: 			Case 61
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0048
L0047:
	MOVF 0x39,W
	SUBLW 0x3D
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0049
; 239: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x39
; 240: 			Case max_pos
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0050
L0049:
	MOVF 0x39,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0051
; 241: 				manual_pos = 61
	MOVLW 0x3D
	MOVWF 0x39
; 242: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0052
L0051:
; 243: 				manual_pos = manual_pos + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 244: 			EndSelect
L0052:
L0050:
L0048:
L0046:
; 245: 			value = manual_pos
	MOVF 0x39,W
	MOVWF 0x30
; 246: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 247: 		Endif
L0044:
; 248: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0053
L0042:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0054
; 249: 		If encoder_count > 0 Then
	MOVF 0x52,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0055
; 250: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x52,W
	MOVWF 0x52
; 251: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0056
L0055:
; 252: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x52
; 253: 			Select Case manual_pos
; 254: 			Case 63
	MOVF 0x39,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0057
; 255: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x39
; 256: 			Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0058
L0057:
	MOVF 0x39,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 257: 				manual_pos = 61
	MOVLW 0x3D
	MOVWF 0x39
; 258: 			Case 61
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0060
L0059:
	MOVF 0x39,W
	SUBLW 0x3D
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0061
; 259: 				manual_pos = max_pos
	MOVF 0x32,W
	MOVWF 0x39
; 260: 			Case 0
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0062
L0061:
	MOVF 0x39,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0063
; 261: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x39
; 262: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0064
L0063:
; 263: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 264: 			EndSelect
L0064:
L0062:
L0060:
L0058:
; 265: 			value = manual_pos
	MOVF 0x39,W
	MOVWF 0x30
; 266: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 267: 		Endif
L0056:
; 268: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0065
L0054:
; 269: 	EndSelect
L0065:
L0053:
; 270: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 271: Return
	RETURN
; 272: 
; 273: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 274: '1 = increasing value
; 275: '2 = decreasing value
; 276: '3 = no change
; 277: 		new_encoder = 0
	CLRF 0x51
; 278: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x51,0
	BTFSS 0x07,4
	BCF 0x51,0
; 279: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x51,1
	BTFSS 0x07,5
	BCF 0x51,1
; 280: 		Select Case old_encoder
; 281: 		Case 0
	MOVF 0x55,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0066
; 282: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x51,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0067
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x3E
L0067:
; 283: 		Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0068
L0066:
	MOVF 0x55,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0069
; 284: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x51,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0070
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x3E
L0070:
; 285: 		Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0071
L0069:
	MOVF 0x55,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0072
; 286: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x51,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0073
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x3E
L0073:
; 287: 		Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0074
L0072:
; 288: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x51,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0075
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x3E
L0075:
; 289: 		EndSelect
L0074:
L0071:
L0068:
; 290: 		old_encoder = new_encoder
	MOVF 0x51,W
	MOVWF 0x55
; 291: Return
	RETURN
; 292: 
; 293: adjust_settings:
L0004:
; 294: 	If program_set = 0 Or program_set = 1 Then  'menu 0 and 1 not available when position has a special value (62, 63)
	MOVF 0x41,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0078
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0077
L0078:
	MOVF 0x41,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0076
L0077:
; 295: 		If act_pos <= max_pos And manual_pos <= max_pos And bus_pos <= max_pos Then
	MOVF 0x31,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0079
	MOVF 0x39,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0079
	MOVF 0x4B,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0079
; 296: 			program_set = program_set
; 297: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0080
L0079:
; 298: 			program_set = 2
	MOVLW 0x02
	MOVWF 0x41
; 299: 		Endif
L0080:
; 300: 	Endif
L0076:
; 301: 	If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,2
	GOTO L0081
; 302: 		swfw = 0
	BCF 0x06,0
; 303: 		swrev = 0
	BCF 0x06,1
; 304: 	Endif
L0081:
; 305: 	Gosub i2c_display_pgm
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0006
; 306: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 307: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 308: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x46,W
	MOVWF 0x36
	MOVF 0x47,W
	MOVWF 0x37
; 309: 	While pgm = 0  'the program switch is still activated
L0082:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0083
; 310: 		If ecsw = 0 Then  'knob is pressed, increase program_set
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0084
; 311: 			program_set = program_set + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 312: 			If program_set > 9 Then  'no more than 9 items te change
	MOVF 0x41,W
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0085
; 313: 				If act_pos <= max_pos And manual_pos <= max_pos And bus_pos <= max_pos Then  'menu 0 and 1 only available when position is not a special position
	MOVF 0x31,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0086
	MOVF 0x39,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0086
	MOVF 0x4B,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0086
; 314: 					program_set = 0
	CLRF 0x41
; 315: 				Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0087
L0086:
; 316: 					program_set = 2
	MOVLW 0x02
	MOVWF 0x41
; 317: 				Endif
L0087:
; 318: 			Endif
L0085:
; 319: 			Gosub i2c_display_pgm
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0006
; 320: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 321: 			While ecsw = 0  'be sure pushbutton is released
L0088:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0089
; 322: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 323: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0088
L0089:
; 324: 		Endif
L0084:
; 325: 		Select Case program_set
; 326: 		Case 0  'correction of current position
	MOVF 0x41,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0090
; 327: 			value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 328: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 329: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 330: 			Select Case result
; 331: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0091
; 332: 				If new_steps < 60000 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 333: 					ena = 1  'motor on
	BSF 0x07,2
; 334: 					new_steps = new_steps + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x37
; 335: 					direction = 1
	BSF 0x07,0
; 336: 					clk = 1  'clock out
	BSF 0x07,1
; 337: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 338: 					clk = 0
	BCF 0x07,1
; 339: 				Endif
L0092:
; 340: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0093
L0091:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0094
; 341: 				If new_steps > 0 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0095
; 342: 					ena = 1  'motor on
	BSF 0x07,2
; 343: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 344: 					direction = 0
	BCF 0x07,0
; 345: 					clk = 1  'clock out
	BSF 0x07,1
; 346: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 347: 					clk = 0
	BCF 0x07,1
; 348: 				Endif
L0095:
; 349: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0096
L0094:
; 350: 			EndSelect
L0096:
L0093:
; 351: 			ena = 0  'motor off
	BCF 0x07,2
; 352: 			Select Case act_pos
; 353: 			Case 1
	MOVF 0x31,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0097
; 354: 				steps_set = 1
	BSF 0x3B,3
; 355: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0098
L0097:
	MOVF 0x31,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0099
; 356: 				If steps_set = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3B,3
	GOTO L0100
; 357: 					If eep = 1 Then  'iF jumper eep1 is set to on
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0101
; 358: 											'routine to set steps for pos 3 to max_pos
; 359: 						value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 360: 						Gosub i2c_display  'show 63 to indicate adjusting is proceeded
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 361: 						If act_steps <> new_steps Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0102
; 362: 							Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0020
; 363: 						Endif
L0102:
; 364: 						act_pos = 1
	MOVLW 0x01
	MOVWF 0x31
; 365: 						new_pos = 2
	MOVLW 0x02
	MOVWF 0x4A
; 366: 						Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 367: 						steps = new_steps - act_steps  'calculate difference between one and two
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x33
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x34
; 368: 						For act_pos = 3 To max_pos
	MOVLW 0x03
	MOVWF 0x31
L0103:
	MOVF 0x31,W
	SUBWF 0x32,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0104
; 369: 							new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x33,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x34,W
	MOVWF 0x37
; 370: 							Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0020
; 371: 						Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0103
L0104:
; 372: 						WaitMs 2000  'give some timne to read display
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 373: 						act_pos = 2  'we were at this position
	MOVLW 0x02
	MOVWF 0x31
; 374: 						steps_set = 0  'do this routine only once
	BCF 0x3B,3
; 375: 					Endif
L0101:
; 376: 				Endif
L0100:
; 377: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0105
L0099:
; 378: 				steps_set = 0
	BCF 0x3B,3
; 379: 			EndSelect  'act_pos
L0105:
L0098:
; 380: 		Case 1  'setting of inverse / not inverse bridge rail power
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0106
L0090:
	MOVF 0x41,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0107
; 381: 			Gosub read_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 382: 			value = 0
	CLRF 0x30
; 383: 			value.0 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,0
	BTFSS 0x3B,0
	BCF 0x30,0
; 384: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 385: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 386: 			Select Case result
; 387: 			Case 1, 2
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0110
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0109
L0110:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
L0109:
; 388: 				bridge_switch = Not bridge_switch
	MOVLW 0x01
	XORWF 0x3B,F
; 389: 				Gosub store_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0019
; 390: 				swfw = bridge_switch
	BTFSC 0x3B,0
	BSF 0x06,0
	BTFSS 0x3B,0
	BCF 0x06,0
; 391: 				swrev = Not bridge_switch
	BTFSS 0x3B,0
	BSF 0x06,1
	BTFSC 0x3B,0
	BCF 0x06,1
; 392: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0111
L0108:
; 393: 			EndSelect
L0111:
; 394: 		Case 2  'setting of maximum positions
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0112
L0107:
	MOVF 0x41,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0113
; 395: 			value = max_pos
	MOVF 0x32,W
	MOVWF 0x30
; 396: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 397: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 398: 			Select Case result
; 399: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0114
; 400: 				max_pos = max_pos + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 401: 				Select Case ctrl_type
; 402: 				Case 6
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0115
; 403: 					If max_pos > 30 Then  'no more positions possible
	MOVF 0x32,W
	SUBLW 0x1E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0116
; 404: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x32
; 405: 					Endif
L0116:
; 406: 				Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0117
L0115:
; 407: 					If max_pos > 47 Then  'no more positions possible
	MOVF 0x32,W
	SUBLW 0x2F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0118
; 408: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x32
; 409: 					Endif
L0118:
; 410: 				EndSelect
L0117:
; 411: 				Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0119:	BTFSC EECON1,WR
	GOTO L0119
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 412: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0120
L0114:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 413: 				max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
; 414: 				If max_pos < 1 Then  'mininum 2 positions
	MOVLW 0x01
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0122
; 415: 					Select Case ctrl_type
; 416: 					Case 6
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0123
; 417: 						max_pos = 30
	MOVLW 0x1E
	MOVWF 0x32
; 418: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0124
L0123:
; 419: 						max_pos = 47
	MOVLW 0x2F
	MOVWF 0x32
; 420: 					EndSelect
L0124:
; 421: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0125:	BTFSC EECON1,WR
	GOTO L0125
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 422: 				Endif
L0122:
; 423: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0126
L0121:
; 424: 			EndSelect
L0126:
L0120:
; 425: 		Case 3  'setting control type
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0127
L0113:
	MOVF 0x41,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0128
; 426: 			If ctrl_type > 6 Then
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0129
; 427: 				ctrl_type = 0
	CLRF 0x38
; 428: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0130:	BTFSC EECON1,WR
	GOTO L0130
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 429: 			Endif
L0129:
; 430: 			value = ctrl_type
	MOVF 0x38,W
	MOVWF 0x30
; 431: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 432: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 433: 			Select Case result
; 434: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0131
; 435: 				ctrl_type = ctrl_type + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 436: 				If ctrl_type = 7 Then
	MOVF 0x38,W
	SUBLW 0x07
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0132
; 437: 					ctrl_type = 0
	CLRF 0x38
; 438: 				Endif
L0132:
; 439: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0133:	BTFSC EECON1,WR
	GOTO L0133
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 440: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0134
L0131:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0135
; 441: 				ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 442: 				If ctrl_type = 255 Then
	MOVF 0x38,W
	SUBLW 0xFF
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0136
; 443: 					ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x38
; 444: 				Endif
L0136:
; 445: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0137:	BTFSC EECON1,WR
	GOTO L0137
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 446: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0138
L0135:
; 447: 			EndSelect
L0138:
L0134:
; 448: 		Case 4  'setting of speed interval Minimum
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0139
L0128:
	MOVF 0x41,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 449: 					'setting will be done in multiple of 256 uSecs
; 450: 					'minimum is 2 and maximum is 99 (is real slow)
; 451: 			value = speed_min.HB
	MOVF 0x3D,W
	MOVWF 0x30
; 452: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 453: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 454: 			Select Case result
; 455: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0141
; 456: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0142
; 457: 					speed_min = speed_min + 256
	MOVF 0x3C,W
	ADDLW 0x00
	MOVWF 0x3C
	MOVF 0x3D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x3D
; 458: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0143:	BTFSC EECON1,WR
	GOTO L0143
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 459: 				Endif
L0142:
; 460: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0144
L0141:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 461: 				If speed_min > speed_max Then
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	MOVF 0x3F,W
	MOVWF R1L
	MOVF 0x40,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0146
; 462: 					speed_min = speed_min - 256
	MOVLW 0x00
	SUBWF 0x3C,W
	MOVWF 0x3C
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 463: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 464: 				Endif
L0146:
; 465: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0148
L0145:
; 466: 			EndSelect
L0148:
L0144:
; 467: 		Case 5  'setting of speed interval Maximum
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0149
L0140:
	MOVF 0x41,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0150
; 468: 					'setting will be done in multiple of 256 uSecs
; 469: 					'minimum is 1 and maximum is 99 (is real slow)
; 470: 			value = speed_max.HB
	MOVF 0x40,W
	MOVWF 0x30
; 471: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 472: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 473: 			Select Case result
; 474: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0151
; 475: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x3D,W
	SUBWF 0x40,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0152
; 476: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 477: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0153:	BTFSC EECON1,WR
	GOTO L0153
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 478: 				Endif
L0152:
; 479: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0154
L0151:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0155
; 480: 				If speed_max.HB > 1 Then
	MOVF 0x40,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0156
; 481: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 482: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0157:	BTFSC EECON1,WR
	GOTO L0157
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 483: 				Endif
L0156:
; 484: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0158
L0155:
; 485: 			EndSelect
L0158:
L0154:
; 486: 		Case 6  'setting of ramp up and down speed
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0159
L0150:
	MOVF 0x41,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0160
; 487: 					'speed_step is the value that speed will be changed every step of the motor (up and down)
; 488: 			value = speed_step
	MOVF 0x49,W
	MOVWF 0x30
; 489: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 490: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 491: 			Select Case result
; 492: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0161
; 493: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x49,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0162
; 494: 					speed_step = speed_step + 1
	MOVF 0x49,W
	ADDLW 0x01
	MOVWF 0x49
; 495: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x49,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0163:	BTFSC EECON1,WR
	GOTO L0163
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 496: 				Endif
L0162:
; 497: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0164
L0161:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0165
; 498: 				If speed_step > 1 Then
	MOVF 0x49,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0166
; 499: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x49,W
	MOVWF 0x49
; 500: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x49,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0167:	BTFSC EECON1,WR
	GOTO L0167
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 501: 				Endif
L0166:
; 502: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0168
L0165:
; 503: 			EndSelect
L0168:
L0164:
; 504: 		Case 7  'setting of extra free space steps
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0169
L0160:
	MOVF 0x41,W
	SUBLW 0x07
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0170
; 505: 			If free_space_steps > 99 Then
	MOVF 0x3A,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0171
; 506: 				free_space_steps = 99
	MOVLW 0x63
	MOVWF 0x3A
; 507: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0172:	BTFSC EECON1,WR
	GOTO L0172
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 508: 			Endif
L0171:
; 509: 			value = free_space_steps
	MOVF 0x3A,W
	MOVWF 0x30
; 510: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 511: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 512: 			Select Case result
; 513: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0173
; 514: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3A,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0174
; 515: 					free_space_steps = free_space_steps + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 516: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0175:	BTFSC EECON1,WR
	GOTO L0175
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 517: 				Endif
L0174:
; 518: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0176
L0173:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0177
; 519: 				If free_space_steps > 0 Then
	MOVF 0x3A,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0178
; 520: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 521: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0179:	BTFSC EECON1,WR
	GOTO L0179
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 522: 				Endif
L0178:
; 523: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0180
L0177:
; 524: 			EndSelect
L0180:
L0176:
; 525: 		Case 8  'setting bridge power and use zero detector options
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0181
L0170:
	MOVF 0x41,W
	SUBLW 0x08
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0182
; 526: 			value2 = 0
	CLRF 0x35
; 527: 			value2.0 = bridge_power  'right digit bridge power off (0) or on (1) when moving,
	BTFSC 0x3B,2
	BSF 0x35,0
	BTFSS 0x3B,2
	BCF 0x35,0
; 528: 			value2.1 = use_zero_detector.0  'left digit 0 do not use 0 detector, 1 use zero detector for position 0, keep free space step setting
	BTFSC 0x45,0
	BSF 0x35,1
	BTFSS 0x45,0
	BCF 0x35,1
; 529: 			value2.2 = use_zero_detector.1  '2 use zero detector for position 0 and correct free space steps
	BTFSC 0x45,1
	BSF 0x35,2
	BTFSS 0x45,1
	BCF 0x35,2
; 530: 			value = use_zero_detector * 10
	MOVF 0x45,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
; 531: 			value.0 = bridge_power
	BTFSC 0x3B,2
	BSF 0x30,0
	BTFSS 0x3B,2
	BCF 0x30,0
; 532: 			If value < 10 Then
	MOVLW 0x0A
	SUBWF 0x30,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0183
; 533: 				value = value + 110  'show left digit 0, not blank
	MOVF 0x30,W
	ADDLW 0x6E
	MOVWF 0x30
; 534: 			Endif
L0183:
; 535: 			version = 0  'turn on decimal point, two settings in one display
	BCF 0x3B,1
; 536: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 537: 			version = 1
	BSF 0x3B,1
; 538: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 539: 			Select Case result
; 540: 			Case 1, 2
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0186
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0185
L0186:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0184
L0185:
; 541: 				value2 = value2 + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
; 542: 				If value2 > 5 Then
	MOVF 0x35,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0187
; 543: 					value2 = 0
	CLRF 0x35
; 544: 				Endif
L0187:
; 545: 				bridge_power = value2.0
	BTFSC 0x35,0
	BSF 0x3B,2
	BTFSS 0x35,0
	BCF 0x3B,2
; 546: 				use_zero_detector.0 = value2.1
	BTFSC 0x35,1
	BSF 0x45,0
	BTFSS 0x35,1
	BCF 0x45,0
; 547: 				use_zero_detector.1 = value2.2
	BTFSC 0x35,2
	BSF 0x45,1
	BTFSS 0x35,2
	BCF 0x45,1
; 548: 				Write mem_bridge_power, value2
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0188:	BTFSC EECON1,WR
	GOTO L0188
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 549: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0189
L0184:
; 550: 			EndSelect
L0189:
; 551: 		Case 9  'setting delay in 0.1s between turning position_match off and start of steppermotor
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0190
L0182:
	MOVF 0x41,W
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0191
; 552: 			value = start_delay
	MOVF 0x44,W
	MOVWF 0x30
; 553: 			If value < 10 Then
	MOVLW 0x0A
	SUBWF 0x30,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0192
; 554: 				value = value + 110  'show the setting with left digit 0 (not blank), like 0.x
	MOVF 0x30,W
	ADDLW 0x6E
	MOVWF 0x30
; 555: 			Endif
L0192:
; 556: 			version = 0  'turn on decimal point, setting is in x.x seconds
	BCF 0x3B,1
; 557: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 558: 			version = 1
	BSF 0x3B,1
; 559: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 560: 			Select Case result
; 561: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0193
; 562: 				If start_delay < 99 Then  'limit is 9.9 seconds
	MOVLW 0x63
	SUBWF 0x44,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0194
; 563: 					start_delay = start_delay + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 564: 					Write mem_start_delay, start_delay
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0195:	BTFSC EECON1,WR
	GOTO L0195
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 565: 				Endif
L0194:
; 566: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0196
L0193:
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0197
; 567: 				If start_delay > 0 Then
	MOVF 0x44,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0198
; 568: 					start_delay = start_delay - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 569: 					Write mem_start_delay, start_delay
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0199:	BTFSC EECON1,WR
	GOTO L0199
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 570: 				Endif
L0198:
; 571: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0200
L0197:
; 572: 			EndSelect
L0200:
L0196:
; 573: 		EndSelect
L0191:
L0190:
L0181:
L0169:
L0159:
L0149:
L0139:
L0127:
L0112:
L0106:
; 574: 	Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0082
L0083:
; 575: 	'***************   now check if changes have to BE written in eeprom
; 576: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0201
; 577: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0020
; 578: 	Endif
L0201:
; 579: 	value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 580: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 581: 	Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 582: Return
	RETURN
; 583: 
; 584: i2c_display:
L0005:
; 585: 	disp1_val = value
	MOVF 0x30,W
	MOVWF 0x4E
; 586: 	disp1_val = disp1_val Mod 10
	MOVF 0x4E,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x4E
; 587: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x4E,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0202
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x4E
L0202:
; 588: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x4E,7
	BTFSS 0x07,7
	BCF 0x4E,7
; 589: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 590: 	I2CSend disp1
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 591: 	I2CSend disp1_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4E,W
	CALL IC01
; 592: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 593: 	disp2_val = value
	MOVF 0x30,W
	MOVWF 0x53
; 594: 	disp2_val = disp2_val / 10
	MOVF 0x53,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x53
; 595: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111, %11000000), disp2_val
	MOVF 0x53,W
	MOVWF R0L
	SUBLW 0x0B
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0203
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x53
L0203:
; 596: 	disp2_val.7 = version
	BTFSC 0x3B,1
	BSF 0x53,7
	BTFSS 0x3B,1
	BCF 0x53,7
; 597: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 598: 	I2CSend disp2
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 599: 	I2CSend disp2_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x53,W
	CALL IC01
; 600: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 601: Return
	RETURN
; 602: 
; 603: i2c_display_pgm:
L0006:
; 604: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x41,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0204
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x4E
L0204:
; 605: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 606: 	I2CSend disp1
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 607: 	I2CSend disp1_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4E,W
	CALL IC01
; 608: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 609: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 610: 	I2CSend disp2
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 611: 	I2CSend %10111111
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 612: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 613: Return
	RETURN
; 614: 
; 615: stepmotor:
L0007:
; 616: 	speed = 0
	CLRF 0x4F
	CLRF 0x50
; 617: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 618: 	If new_steps > 65532 Then  'special position 61, 62 or 63 selected
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0xFC
	MOVWF R1L
	MOVLW 0xFF
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0205
; 619: 		If new_steps = 65533 Then  'goto 0 position counterclockwise
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0xFD
	MOVWF R1L
	MOVLW 0xFF
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
; 620: 			direction = 1  'go counterclockwise
	BSF 0x07,0
; 621: 			ena = 1  'set enable on
	BSF 0x07,2
; 622: 			While zero = 1  'turn motor until zero switch is activated
L0207:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0208
; 623: 				Gosub stepper_max_speed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 624: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0207
L0208:
; 625: 			While zero = 0  'continue to run until zero detector no longer signals
L0209:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0210
; 626: 				Gosub stepper_max_speed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 627: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0209
L0210:
; 628: 			WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 629: 			direction = 0  'now go clockwise
	BCF 0x07,0
; 630: 			free_space_word = 0
	CLRF 0x4C
	CLRF 0x4D
; 631: 			While zero = 1  'run until zero detector signals
L0211:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0212
; 632: 				Gosub stepper_max_speed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 633: 				free_space_word = free_space_word + 1
	MOVF 0x4C,W
	ADDLW 0x01
	MOVWF 0x4C
	MOVF 0x4D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x4D
; 634: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0211
L0212:
; 635: 			free_space_steps = free_space_word / 4
;       The address of 'oshonsoft_temp_1' (word) (global) is 0x60
	oshonsoft_temp_1 EQU 0x60
	MOVF 0x4C,W
	MOVWF R0L
	MOVF 0x4D,W
	MOVWF R0H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x60
	MOVF R0H,W
	MOVWF 0x61
	MOVF 0x60,W
	MOVWF 0x3A
; 636: 			If free_space_steps > 99 Then
	MOVF 0x3A,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0213
; 637: 				free_space_steps = 99
	MOVLW 0x63
	MOVWF 0x3A
; 638: 			Endif
L0213:
; 639: 			If use_zero_detector > 1 Then  'update free space steps stetting
	MOVF 0x45,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0214
; 640: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0215:	BTFSC EECON1,WR
	GOTO L0215
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 641: 			Endif
L0214:
; 642: 			value = free_space_steps
	MOVF 0x3A,W
	MOVWF 0x30
; 643: 			Gosub i2c_display  'show number of steps needed, indication of free_space_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 644: 			WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 645: 		Else  'goto 0 detector position clockwise
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0216
L0206:
; 646: 			direction = 0
	BCF 0x07,0
; 647: 			ena = 1  'set enable on
	BSF 0x07,2
; 648: 			While zero = 1  'turn motor until zero switch is activated
L0217:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0218
; 649: 				Gosub stepper_max_speed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 650: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0217
L0218:
; 651: 		Endif
L0216:
; 652: 		ena = 0  'set enable off
	BCF 0x07,2
; 653: 		If act_steps = 0 Then  'position 61 or 62 choosen
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0219
; 654: 			new_pos = 0
	CLRF 0x4A
; 655: 		Else  'one_round count to be done
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0220
L0219:
; 656: 			act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 657: 			Gosub check_0_pass_allowed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0010
; 658: 			steps = 0
	CLRF 0x33
	CLRF 0x34
; 659: 			If direction = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0221
; 660: 				one_round = 0  'start counting one round steps
	CLRF 0x42
	CLRF 0x43
; 661: 				ena = 1  'set enable on
	BSF 0x07,2
; 662: 				While zero = 0  'turn motor until zero switch is DISactivated
L0222:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0223
; 663: 					Gosub stepper_max_speed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 664: 					one_round = one_round + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x43,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x43
; 665: 				Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0222
L0223:
; 666: 				For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
	MOVLW 0x01
	MOVWF 0x30
L0224:
	MOVF 0x30,W
	SUBLW 0x64
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0225
; 667: 					Gosub stepper_max_speed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 668: 					one_round = one_round + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x43,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x43
; 669: 				Next value
	MOVLW 0x01
	ADDWF 0x30,F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0224
L0225:
; 670: 				While zero = 1  'turn motor until zero switch is activated
L0226:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0227
; 671: 					Gosub stepper_max_speed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 672: 					one_round = one_round + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x43,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x43
; 673: 				Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0226
L0227:
; 674: 				one_round_half = one_round / 2
	MOVF 0x42,W
	MOVWF R0L
	MOVF 0x43,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x59
	MOVF R0H,W
	MOVWF 0x5A
; 675: 				Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0228:	BTFSC EECON1,WR
	GOTO L0228
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 676: 				Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0229:	BTFSC EECON1,WR
	GOTO L0229
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 677: 				act_pos = 63
	MOVLW 0x3F
	MOVWF 0x31
; 678: 				ena = 0  'motor off
	BCF 0x07,2
; 679: 			Endif
L0221:
; 680: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0230:	BTFSC EECON1,WR
	GOTO L0230
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 681: 		Endif
L0220:
; 682: 	Else  'this is the normal position sequence
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0231
L0205:
; 683: 		steps = 0
	CLRF 0x33
	CLRF 0x34
; 684: 		If new_steps > act_steps Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0232
; 685: 			steps = new_steps - act_steps
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x33
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x34
; 686: 			direction = 1
	BSF 0x07,0
; 687: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x59,W
	MOVWF R1L
	MOVF 0x5A,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0233
; 688: 				Gosub check_0_pass_allowed  'check if other direction is allowed
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0010
; 689: 			Endif
L0233:
; 690: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0234
L0232:
; 691: 			steps = act_steps - new_steps
	MOVF 0x36,W
	SUBWF 0x46,W
	MOVWF 0x33
	MOVF 0x37,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x47,W
	MOVWF 0x34
; 692: 			direction = 0
	BCF 0x07,0
; 693: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x59,W
	MOVWF R1L
	MOVF 0x5A,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0235
; 694: 				Gosub check_0_pass_allowed  'check if other direction is allowed
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0010
; 695: 			Endif
L0235:
; 696: 		Endif
L0234:
; 697: 		If steps > 0 Then  'motor must be activated
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0236
; 698: 			If direction = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0237
; 699: 				steps = steps + free_space_word
	MOVF 0x33,W
	ADDWF 0x4C,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x4D,W
	MOVWF 0x34
; 700: 			Endif
L0237:
; 701: 			ramp_up = 1
	BSF 0x3B,4
; 702: 			ramp_down_point = 0
	CLRF 0x57
	CLRF 0x58
; 703: 			half_steps = steps / 2
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5E
	MOVF R0H,W
	MOVWF 0x5F
; 704: 			speed = speed_min
	MOVF 0x3C,W
	MOVWF 0x4F
	MOVF 0x3D,W
	MOVWF 0x50
; 705: 			ena = 1  'set enable on
	BSF 0x07,2
; 706: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0238:
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0239
; 707: 				If max_end = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0240
; 708: 					Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0021
; 709: 				Endif
L0240:
; 710: 				If ctrl_type = 6 And fy_stop = 1 Then
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0241
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,5
	GOTO L0241
; 711: 					Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0021
; 712: 				Endif
L0241:
; 713: 				clk = 1  'clock out
	BSF 0x07,1
; 714: 				WaitUs speed
	MOVF 0x4F,W
	MOVWF R4L
	MOVF 0x50,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 715: 				clk = 0
	BCF 0x07,1
; 716: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 717: 				If new_pos = 0 And zero = 0 And use_zero_detector > 0 Then  'reached 0 detector and using it for pos 0
	MOVF 0x4A,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0242
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0242
	MOVF 0x45,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0242
; 718: 					Gosub step_to_zero_detector
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0009
; 719: 				Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0243
L0242:
; 720: 					If steps = 1 And new_pos = 0 And zero = 1 And use_zero_detector > 0 Then  'using zero detector, but at end of steps and detector not yet reached
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVLW 0x01
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0244
	MOVF 0x4A,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0244
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0244
	MOVF 0x45,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0244
; 721: 						While zero = 1  'continue running until zero detector reached
L0245:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0246
; 722: 							Gosub stepper_calc_speed
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0012
; 723: 						Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0245
L0246:
; 724: 						Gosub step_to_zero_detector
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0009
; 725: 					Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0247
L0244:
; 726: 						steps = steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 727: 					Endif
L0247:
; 728: 				Endif
L0243:
; 729: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0238
L0239:
; 730: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 731: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0248
; 732: 				steps = free_space_word
	MOVF 0x4C,W
	MOVWF 0x33
	MOVF 0x4D,W
	MOVWF 0x34
; 733: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 734: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0249:
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0250
; 735: 					If max_end = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0251
; 736: 						Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0021
; 737: 					Endif
L0251:
; 738: 					If ctrl_type = 6 And fy_stop = 1 Then
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0252
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,5
	GOTO L0252
; 739: 						Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0021
; 740: 					Endif
L0252:
; 741: 					clk = 1  'clock out
	BSF 0x07,1
; 742: 					WaitUs speed_min
	MOVF 0x3C,W
	MOVWF R4L
	MOVF 0x3D,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 743: 					clk = 0
	BCF 0x07,1
; 744: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 745: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 746: 				Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0249
L0250:
; 747: 			Endif
L0248:
; 748: 			ena = 0  'enable off
	BCF 0x07,2
; 749: 		Endif
L0236:
; 750: 	Endif
L0231:
; 751: 	act_pos = new_pos
	MOVF 0x4A,W
	MOVWF 0x31
; 752: 	Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0253:	BTFSC EECON1,WR
	GOTO L0253
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 753: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4B
; 754: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x5B
; 755: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x39
; 756: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x56
; 757: Return
	RETURN
; 758: 
; 759: speed_calc:
L0008:
; 760: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x5E,W
	MOVWF R1L
	MOVF 0x5F,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0254
; 761: 		ramp_up = 0
	BCF 0x3B,4
; 762: 	Endif
L0254:
; 763: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3B,4
	GOTO L0255
; 764: 		If speed > speed_max Then
	MOVF 0x4F,W
	MOVWF R0L
	MOVF 0x50,W
	MOVWF R0H
	MOVF 0x3F,W
	MOVWF R1L
	MOVF 0x40,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0256
; 765: 			speed = speed - speed_step
	MOVF 0x49,W
	SUBWF 0x4F,W
	MOVWF 0x4F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x50,W
	MOVWF 0x50
; 766: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x57,W
	ADDLW 0x01
	MOVWF 0x57
	MOVF 0x58,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x58
; 767: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0257
L0256:
; 768: 			ramp_up = 0
	BCF 0x3B,4
; 769: 		Endif
L0257:
; 770: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0258
L0255:
; 771: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x57,W
	MOVWF R1L
	MOVF 0x58,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0259
; 772: 			If speed < speed_min Then
	MOVF 0x4F,W
	MOVWF R0L
	MOVF 0x50,W
	MOVWF R0H
	MOVF 0x3C,W
	MOVWF R1L
	MOVF 0x3D,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0260
; 773: 				speed = speed + speed_step
	MOVF 0x4F,W
	ADDWF 0x49,W
	MOVWF 0x4F
	MOVF 0x50,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x50
; 774: 			Endif
L0260:
; 775: 		Endif
L0259:
; 776: 	Endif
L0258:
; 777: Return
	RETURN
; 778: 
; 779: step_to_zero_detector:
L0009:
; 780: 	If direction = 1 Then  'going counter-clockwise
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0261
; 781: 		While zero = 0  'run past zero detector
L0262:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0263
; 782: 			Gosub stepper_calc_speed
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0012
; 783: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0262
L0263:
; 784: 		WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 785: 		direction = 0  'now go clockwise
	BCF 0x07,0
; 786: 		free_space_word = 0
	CLRF 0x4C
	CLRF 0x4D
; 787: 		While zero = 1  'run until zero detector signals
L0264:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,3
	GOTO L0265
; 788: 			Gosub stepper_calc_speed
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0012
; 789: 			free_space_word = free_space_word + 1
	MOVF 0x4C,W
	ADDLW 0x01
	MOVWF 0x4C
	MOVF 0x4D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x4D
; 790: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0264
L0265:
; 791: 		free_space_steps = free_space_word / 4
	MOVF 0x4C,W
	MOVWF R0L
	MOVF 0x4D,W
	MOVWF R0H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x60
	MOVF R0H,W
	MOVWF 0x61
	MOVF 0x60,W
	MOVWF 0x3A
; 792: 		If free_space_steps > 99 Then
	MOVF 0x3A,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0266
; 793: 			free_space_steps = 99
	MOVLW 0x63
	MOVWF 0x3A
; 794: 		Endif
L0266:
; 795: 		If use_zero_detector > 1 Then  'update free space steps stetting
	MOVF 0x45,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0267
; 796: 			Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0268:	BTFSC EECON1,WR
	GOTO L0268
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 797: 		Endif
L0267:
; 798: 		value = free_space_steps
	MOVF 0x3A,W
	MOVWF 0x30
; 799: 		Gosub i2c_display  'show number of steps needed, indication of free_space_steps
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 800: 	Endif
L0261:
; 801: 	steps = 0
	CLRF 0x33
	CLRF 0x34
; 802: Return
	RETURN
; 803: 
; 804: check_0_pass_allowed:
L0010:
; 805: 	Select Case ctrl_type
; 806: 	Case 2, 3  'check if extra round is allowed
	MOVF 0x38,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0271
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0270
L0271:
	MOVF 0x38,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0269
L0270:
; 807: 		Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x48
; 808: 		If turn_counter > 126 And direction = 1 Then  'extra round in direction 0 allowed
	MOVF 0x48,W
	SUBLW 0x7E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0272
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0272
; 809: 			turn_counter = turn_counter - 1  'substract 1 pass
	MOVLW 0x01
	SUBWF 0x48,W
	MOVWF 0x48
; 810: 			Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0273:	BTFSC EECON1,WR
	GOTO L0273
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 811: 			direction = 0  'change direction
	BCF 0x07,0
; 812: 			steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x33,W
	SUBWF 0x42,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x43,W
	MOVWF 0x34
; 813: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0274
L0272:
; 814: 			If turn_counter < 130 And direction = 0 Then  'extra round in direction 1 allowed
	MOVLW 0x82
	SUBWF 0x48,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0275
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,0
	GOTO L0275
; 815: 				turn_counter = turn_counter + 1
	MOVF 0x48,W
	ADDLW 0x01
	MOVWF 0x48
; 816: 				Write mem_turn_counter, turn_counter  'add 1 pass
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0276:	BTFSC EECON1,WR
	GOTO L0276
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 817: 				direction = 1  'change direction
	BSF 0x07,0
; 818: 				steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x33,W
	SUBWF 0x42,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x43,W
	MOVWF 0x34
; 819: 			Endif
L0275:
; 820: 		Endif
L0274:
; 821: 	Case 4, 5  'type with contact sliders, always allow
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0277
L0269:
	MOVF 0x38,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0280
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0279
L0280:
	MOVF 0x38,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0278
L0279:
; 822: 		direction = Not direction  'change direction
	MOVLW 0x01
	XORWF 0x07,F
; 823: 		steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x33,W
	SUBWF 0x42,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x43,W
	MOVWF 0x34
; 824: 	Case Else  'other types do not allow pass through 0 position, no direction change
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0281
L0278:
; 825: 	EndSelect
L0281:
L0277:
; 826: Return
	RETURN
; 827: 
; 828: stepper_max_speed:  'step at max speed
L0011:
; 829: 	clk = 1  'clock out
	BSF 0x07,1
; 830: 	WaitUs speed_max
	MOVF 0x3F,W
	MOVWF R4L
	MOVF 0x40,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 831: 	clk = 0
	BCF 0x07,1
; 832: 	WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 833: Return
	RETURN
; 834: 
; 835: stepper_calc_speed:  'step at calculated speed (ramp up/down)
L0012:
; 836: 	clk = 1  'clock out
	BSF 0x07,1
; 837: 	WaitUs speed
	MOVF 0x4F,W
	MOVWF R4L
	MOVF 0x50,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 838: 	clk = 0
	BCF 0x07,1
; 839: 	WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 840: Return
	RETURN
; 841: 
; 842: set_relays:
L0013:
; 843: 	Gosub read_bridge_switch
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0018
; 844: 	If bridge_power = 0 Then  'bridge railpower must be switched on
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x3B,2
	GOTO L0282
; 845: 		Select Case ctrl_type
; 846: 		Case 1, 3, 5, 6
	MOVF 0x38,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0285
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0284
L0285:
	MOVF 0x38,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0286
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0284
L0286:
	MOVF 0x38,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0287
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0284
L0287:
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0283
L0284:
; 847: 			swfw = 0
	BCF 0x06,0
; 848: 			swrev = 1
	BSF 0x06,1
; 849: 		Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0288
L0283:
; 850: 			swfw = bridge_switch
	BTFSC 0x3B,0
	BSF 0x06,0
	BTFSS 0x3B,0
	BCF 0x06,0
; 851: 			swrev = Not bridge_switch
	BTFSS 0x3B,0
	BSF 0x06,1
	BTFSC 0x3B,0
	BCF 0x06,1
; 852: 		EndSelect
L0288:
; 853: 	Else  'BRIDGE IS ALWAYS ON
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0289
L0282:
; 854: 		If bridge_switch <> old_bridge_switch Then  'polarisation must be changed
	CLRW
	BTFSC 0x3B,0
	ADDLW 0x01
	BTFSC 0x3B,5
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0290
; 855: 			swfw = bridge_switch
	BTFSC 0x3B,0
	BSF 0x06,0
	BTFSS 0x3B,0
	BCF 0x06,0
; 856: 			swrev = Not bridge_switch
	BTFSS 0x3B,0
	BSF 0x06,1
	BTFSC 0x3B,0
	BCF 0x06,1
; 857: 			old_bridge_switch = bridge_switch
	BTFSC 0x3B,0
	BSF 0x3B,5
	BTFSS 0x3B,0
	BCF 0x3B,5
; 858: 		Endif
L0290:
; 859: 	Endif
L0289:
; 860: Return
	RETURN
; 861: 
; 862: init_eeprom:
L0014:
; 863: 	If pgm = 0 Then  'special for my own fiddle yard
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0291
; 864: 		new_steps = 178
	MOVLW 0xB2
	MOVWF 0x36
	CLRF 0x37
; 865: 		For act_pos = 0 To 11
	CLRF 0x31
L0292:
	MOVF 0x31,W
	SUBLW 0x0B
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0293
; 866: 			Gosub save_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0020
; 867: 			new_steps = new_steps + 4300
	MOVF 0x36,W
	ADDLW 0xCC
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x10
	MOVWF 0x37
; 868: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0292
L0293:
; 869: 		Write mem_max_pos, 11
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x0B
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0294:	BTFSC EECON1,WR
	GOTO L0294
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 870: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x32
; 871: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0295
L0291:
; 872: 		new_steps = 0
	CLRF 0x36
	CLRF 0x37
; 873: 		steps = one_round / (max_pos + 1)  'devide the steps between min and max
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x33
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x34
	MOVF 0x42,W
	MOVWF R0L
	MOVF 0x43,W
	MOVWF R0H
	MOVF 0x33,W
	MOVWF R1L
	MOVF 0x34,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x33
	MOVF R0H,W
	MOVWF 0x34
; 874: 		For act_pos = 0 To max_pos
	CLRF 0x31
L0296:
	MOVF 0x31,W
	SUBWF 0x32,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0297
; 875: 			Gosub save_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0020
; 876: 			bridge_switch = 0
	BCF 0x3B,0
; 877: 			Gosub store_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0019
; 878: 			new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x33,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x34,W
	MOVWF 0x37
; 879: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0296
L0297:
; 880: 	Endif
L0295:
; 881: 	act_pos = 0
	CLRF 0x31
; 882: 	Write mem_act_pos, act_pos  'act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0298:	BTFSC EECON1,WR
	GOTO L0298
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 883: Return
	RETURN
; 884: 
; 885: init_values:
L0015:
; 886: 	version = 0  'decimal point in display on
	BCF 0x3B,1
; 887: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 888: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 889: 	version = 1  'decimal point in display off
	BSF 0x3B,1
; 890: 	encoder_count = 0
	CLRF 0x52
; 891: 	speed_min = 0
	CLRF 0x3C
	CLRF 0x3D
; 892: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 893: 	If speed_min.HB > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0299
; 894: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3D
; 895: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0300
L0299:
; 896: 		If speed_min.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3D,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0301
; 897: 			speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3D
; 898: 		Endif
L0301:
; 899: 	Endif
L0300:
; 900: 	speed_max = 0
	CLRF 0x3F
	CLRF 0x40
; 901: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 902: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x40,W
	SUBWF 0x3D,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0302
; 903: 		speed_max.HB = speed_min.HB
	MOVF 0x3D,W
	MOVWF 0x40
; 904: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0303
L0302:
; 905: 		If speed_max.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x40,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0304
; 906: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x40
; 907: 		Endif
L0304:
; 908: 	Endif
L0303:
; 909: 
; 910: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 911: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x43
; 912: 	If one_round = 0 Then
	MOVF 0x42,W
	MOVWF R0L
	MOVF 0x43,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0305
; 913: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x42
	MOVLW 0x1F
	MOVWF 0x43
; 914: 	Endif
L0305:
; 915: 	If one_round > 60000 Then
	MOVF 0x42,W
	MOVWF R0L
	MOVF 0x43,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0306
; 916: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x42
	MOVLW 0x1F
	MOVWF 0x43
; 917: 	Endif
L0306:
; 918: 	one_round_half = one_round / 2
	MOVF 0x42,W
	MOVWF R0L
	MOVF 0x43,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x59
	MOVF R0H,W
	MOVWF 0x5A
; 919: 
; 920: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 921: 	If ctrl_type > 6 Then
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0307
; 922: 		ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x38
; 923: 	Endif
L0307:
; 924: 
; 925: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 926: 	Select Case ctrl_type
; 927: 	Case 6
	MOVF 0x38,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0308
; 928: 		If max_pos > 30 Then
	MOVF 0x32,W
	SUBLW 0x1E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0309
; 929: 			max_pos = 12
	MOVLW 0x0C
	MOVWF 0x32
; 930: 		Endif
L0309:
; 931: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0310
L0308:
; 932: 		If max_pos > 47 Then
	MOVF 0x32,W
	SUBLW 0x2F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0311
; 933: 			max_pos = 47
	MOVLW 0x2F
	MOVWF 0x32
; 934: 		Endif
L0311:
; 935: 	EndSelect
L0310:
; 936: 	Read mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 937: 	If act_pos > max_pos Then
	MOVF 0x31,W
	SUBWF 0x32,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0312
; 938: 		act_pos = 0
	CLRF 0x31
; 939: 	Endif
L0312:
; 940: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 941: 	If free_space_steps > 99 Then
	MOVF 0x3A,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0313
; 942: 		free_space_steps = 0
	CLRF 0x3A
; 943: 	Endif
L0313:
; 944: 
; 945: 	Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x48
; 946: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x48,W
	SUBLW 0x83
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0314
; 947: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x48
; 948: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0315
L0314:
; 949: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x48,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0316
; 950: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x48
; 951: 		Endif
L0316:
; 952: 	Endif
L0315:
; 953: 	
; 954: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x49
; 955: 	If speed_step > 99 Then
	MOVF 0x49,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0317
; 956: 		speed_step = 0
	CLRF 0x49
; 957: 	Endif
L0317:
; 958: 	
; 959: 	Read mem_start_delay, start_delay
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 960: 	If start_delay > 99 Then  'limit is 9.9 seconds
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0318
; 961: 		start_delay = 0
	CLRF 0x44
; 962: 	Endif
L0318:
; 963: 	
; 964: 	Read mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 965: 	If value > 5 Then
	MOVF 0x30,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0319
; 966: 		value = 0
	CLRF 0x30
; 967: 	Endif
L0319:
; 968: 	bridge_power = value.0
	BTFSC 0x30,0
	BSF 0x3B,2
	BTFSS 0x30,0
	BCF 0x3B,2
; 969: 	use_zero_detector = 0
	CLRF 0x45
; 970: 	use_zero_detector.0 = value.1
	BTFSC 0x30,1
	BSF 0x45,0
	BTFSS 0x30,1
	BCF 0x45,0
; 971: 	use_zero_detector.1 = value.2
	BTFSC 0x30,2
	BSF 0x45,1
	BTFSS 0x30,2
	BCF 0x45,1
; 972: 
; 973: 	If eep = 1 Then  'jumper set for initialisation
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0320
; 974: 		Gosub init_eeprom
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0014
; 975: 	Endif
L0320:
; 976: 	ena = 0
	BCF 0x07,2
; 977: 	steps_set = 0
	BCF 0x3B,3
; 978: 	new_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4A
; 979: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4B
; 980: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x5B
; 981: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x39
; 982: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x56
; 983: Return
	RETURN
; 984: 
; 985: steps_reading:
L0016:
; 986: 	Select Case new_pos
; 987: 	Case 63
	MOVF 0x4A,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0321
; 988: 		new_steps = 65534
	MOVLW 0xFE
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 989: 		act_steps = 1
	MOVLW 0x01
	MOVWF 0x46
	CLRF 0x47
; 990: 	Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0322
L0321:
	MOVF 0x4A,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0323
; 991: 		new_steps = 65534
	MOVLW 0xFE
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 992: 		act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 993: 	Case 61
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0324
L0323:
	MOVF 0x4A,W
	SUBLW 0x3D
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0325
; 994: 		new_steps = 65533
	MOVLW 0xFD
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 995: 		act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 996: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0326
L0325:
; 997: 		eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x54
; 998: 		Read act_pos, act_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 999: 		Read eprom_pointer, act_steps.HB
	MOVF 0x54,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x47
; 1000: 		eprom_pointer = new_pos + 48
	MOVF 0x4A,W
	ADDLW 0x30
	MOVWF 0x54
; 1001: 		Read new_pos, new_steps.LB
	MOVF 0x4A,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 1002: 		Read eprom_pointer, new_steps.HB
	MOVF 0x54,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 1003: 		Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 1004: 		free_space_word = free_space_steps * 4
	MOVF 0x3A,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x4C
	MOVF R2H,W
	MOVWF 0x4D
; 1005: 	EndSelect
L0326:
L0324:
L0322:
; 1006: Return
	RETURN
; 1007: 
; 1008: get_bridge_switch:
L0017:
; 1009: 	Select Case act_pos
; 1010: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0327
; 1011: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1012: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0328
L0327:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0329
; 1013: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1014: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0330
L0329:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0331
; 1015: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1016: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0332
L0331:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0333
; 1017: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1018: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0334
L0333:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0335
; 1019: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1020: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0336
L0335:
; 1021: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1022: 	EndSelect
L0336:
L0334:
L0332:
L0330:
L0328:
; 1023: Return
	RETURN
; 1024: 
; 1025: read_bridge_switch:
L0018:
; 1026: 	Gosub get_bridge_switch
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0017
; 1027: 	value2 = act_pos Mod 8
	MOVF 0x31,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x35
; 1028: 	Select Case value2
; 1029: 	Case 0
	MOVF 0x35,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0337
; 1030: 		bridge_switch = value.0
	BTFSC 0x30,0
	BSF 0x3B,0
	BTFSS 0x30,0
	BCF 0x3B,0
; 1031: 	Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0338
L0337:
	MOVF 0x35,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0339
; 1032: 		bridge_switch = value.1
	BTFSC 0x30,1
	BSF 0x3B,0
	BTFSS 0x30,1
	BCF 0x3B,0
; 1033: 	Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0340
L0339:
	MOVF 0x35,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0341
; 1034: 		bridge_switch = value.2
	BTFSC 0x30,2
	BSF 0x3B,0
	BTFSS 0x30,2
	BCF 0x3B,0
; 1035: 	Case 3
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0342
L0341:
	MOVF 0x35,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0343
; 1036: 		bridge_switch = value.3
	BTFSC 0x30,3
	BSF 0x3B,0
	BTFSS 0x30,3
	BCF 0x3B,0
; 1037: 	Case 4
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0344
L0343:
	MOVF 0x35,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0345
; 1038: 		bridge_switch = value.4
	BTFSC 0x30,4
	BSF 0x3B,0
	BTFSS 0x30,4
	BCF 0x3B,0
; 1039: 	Case 5
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0346
L0345:
	MOVF 0x35,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0347
; 1040: 		bridge_switch = value.5
	BTFSC 0x30,5
	BSF 0x3B,0
	BTFSS 0x30,5
	BCF 0x3B,0
; 1041: 	Case 6
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0348
L0347:
	MOVF 0x35,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0349
; 1042: 		bridge_switch = value.6
	BTFSC 0x30,6
	BSF 0x3B,0
	BTFSS 0x30,6
	BCF 0x3B,0
; 1043: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0350
L0349:
; 1044: 		bridge_switch = value.7
	BTFSC 0x30,7
	BSF 0x3B,0
	BTFSS 0x30,7
	BCF 0x3B,0
; 1045: 	EndSelect
L0350:
L0348:
L0346:
L0344:
L0342:
L0340:
L0338:
; 1046: Return
	RETURN
; 1047: 
; 1048: store_bridge_switch:
L0019:
; 1049: 	Gosub get_bridge_switch
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0017
; 1050: 	value2 = act_pos
	MOVF 0x31,W
	MOVWF 0x35
; 1051: 	value2 = value2 Mod 8
	MOVF 0x35,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x35
; 1052: 	Select Case value2
; 1053: 	Case 0
	MOVF 0x35,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0351
; 1054: 		value.0 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,0
	BTFSS 0x3B,0
	BCF 0x30,0
; 1055: 	Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0352
L0351:
	MOVF 0x35,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0353
; 1056: 		value.1 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,1
	BTFSS 0x3B,0
	BCF 0x30,1
; 1057: 	Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0354
L0353:
	MOVF 0x35,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0355
; 1058: 		value.2 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,2
	BTFSS 0x3B,0
	BCF 0x30,2
; 1059: 	Case 3
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0356
L0355:
	MOVF 0x35,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0357
; 1060: 		value.3 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,3
	BTFSS 0x3B,0
	BCF 0x30,3
; 1061: 	Case 4
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0358
L0357:
	MOVF 0x35,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0359
; 1062: 		value.4 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,4
	BTFSS 0x3B,0
	BCF 0x30,4
; 1063: 	Case 5
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0360
L0359:
	MOVF 0x35,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0361
; 1064: 		value.5 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,5
	BTFSS 0x3B,0
	BCF 0x30,5
; 1065: 	Case 6
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0362
L0361:
	MOVF 0x35,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0363
; 1066: 		value.6 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,6
	BTFSS 0x3B,0
	BCF 0x30,6
; 1067: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0364
L0363:
; 1068: 		value.7 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,7
	BTFSS 0x3B,0
	BCF 0x30,7
; 1069: 	EndSelect
L0364:
L0362:
L0360:
L0358:
L0356:
L0354:
L0352:
; 1070: 	Select Case act_pos
; 1071: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0365
; 1072: 		Write mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0366:	BTFSC EECON1,WR
	GOTO L0366
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1073: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0367
L0365:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0368
; 1074: 		Write mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0369:	BTFSC EECON1,WR
	GOTO L0369
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1075: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0370
L0368:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0371
; 1076: 		Write mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0372:	BTFSC EECON1,WR
	GOTO L0372
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1077: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0373
L0371:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0374
; 1078: 		Write mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0375:	BTFSC EECON1,WR
	GOTO L0375
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1079: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0376
L0374:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0377
; 1080: 		Write mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0378:	BTFSC EECON1,WR
	GOTO L0378
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1081: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0379
L0377:
; 1082: 		Write mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0380:	BTFSC EECON1,WR
	GOTO L0380
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1083: 	EndSelect
L0379:
L0376:
L0373:
L0370:
L0367:
; 1084: Return
	RETURN
; 1085: 
; 1086: save_steps:
L0020:
; 1087: 	eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x54
; 1088: 	Write act_pos, new_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0381:	BTFSC EECON1,WR
	GOTO L0381
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1089: 	Write eprom_pointer, new_steps.HB
	MOVF 0x54,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0382:	BTFSC EECON1,WR
	GOTO L0382
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1090: Return
	RETURN
; 1091: 
; 1092: stop_the_motor:
L0021:
; 1093: 	While ecsw = 1
L0383:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,6
	GOTO L0384
; 1094: 		version = Not version
	MOVLW 0x02
	XORWF 0x3B,F
; 1095: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 1096: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 1097: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0383
L0384:
; 1098: 	If version = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,1
	GOTO L0385
; 1099: 		version = 1
	BSF 0x3B,1
; 1100: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 1101: 	Endif
L0385:
; 1102: Return
	RETURN
; End of program
;       PAGE SELECT
;	BCF PCLATH,3
L0386:	GOTO L0386
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
