Define CONFIG = 0x33c4


'program GCA198
'this is the version for GCA198 with dip-switch and PIC16F688 processor
'SW1-1 is ON for full step and OF  for half step
'SW1-2 is ON for forward and OFF for reverse
'program is universal for monophase stepper motors (5 connections )
'mainly issued for use with steppermotor 28BYJ-48
Define STEP_A_REG = PORTC
Define STEP_A_BIT = 3
Define STEP_B_REG = PORTC
Define STEP_B_BIT = 4
Define STEP_C_REG = PORTC
Define STEP_C_BIT = 5
Define STEP_D_REG = PORTC
Define STEP_D_BIT = 2
If RC0 = 0 Then  'half step selected
	Define STEP_MODE = 2
Else  'full step mode
	Define STEP_MODE = 1
Endif

TRISA = %111011
TRISC = %000011
AllDigital
ANSEL = %110000
StepHold
Dim servo_speed As Word
Dim pause_time As Word
Dim program As Byte
Dim pause_timer As Word
Dim old_pause_timer As Word
Symbol led = RA2
Symbol fw_rev = RC1
OPTION_REG.T0CS = 0  'bit 5 TMR0 Clock Source Select bit:0=Internal Clock (CLKO) / 1=Transition on T0CKI pin
OPTION_REG.T0SE = 0  'bit 4 TMR0 Source Edge Select bit: 0=low/high / 1=high/low
OPTION_REG.PSA = 0  'bit 3 Prescaler Assignment bit: 0=Prescaler is assigned to the WDT
OPTION_REG.PS2 = 0  'bits 2-0  PS2:PS0: Prescaler Rate Select bits
OPTION_REG.PS1 = 0
OPTION_REG.PS0 = 0
TMR0 = 56  'preset for timer register

led = 1  'LED OFF
Adcin 4, servo_speed
servo_speed = servo_speed * 60
servo_speed = servo_speed + 500
Adcin 5, pause_time
program = 0
pause_timer = 0
Enable
main:
	Adcin 2, servo_speed
	servo_speed = servo_speed * 60
	servo_speed = servo_speed + 500
	If pause_time < 50 Then  'continous run
		If fw_rev = 1 Then
			StepCW 1, servo_speed
		Else
			StepCCW 1, servo_speed
		Endif
		led = 0
	Else
							'NOW p1 IS USED FOR INTERVAL SET
		Adcin 2, pause_time
		Select Case program
		Case 0  'motor runs
			If pause_timer < pause_time Then
				pause_timer = pause_timer + 1
				If fw_rev = 1 Then
					StepCW 1, servo_speed
				Else
					StepCCW 1, servo_speed
				Endif
				led = 0
			Else
				pause_timer = 0
				program = 1
			Endif
		Case Else  'motor stop, interval timing
			While old_pause_timer = pause_timer
			Wend
			old_pause_timer = pause_timer
			If pause_timer < pause_time Then
				pause_timer = pause_timer + 1
				led = pause_timer.3
			Else
				pause_timer = 0
				program = 0
			Endif
		EndSelect
	Endif
	Goto main
End                                               
On Interrupt  'this routine increases speed_timer each 1/100 second
	pause_timer = pause_timer + 1  'counts 100x pro second, so p2 set full = 1023 = 10,23 secs
	TMR0 = 59
	INTCON.T0IF = 0  'clear timer interrupt flag
	INTCON.GIE = 1
Resume                                            