; Compiled with: PIC Simulator IDE v7.51
; Microcontroller model: PIC16F688
; Clock frequency: 8.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R3H EQU 0x027
	R4L EQU 0x028
	R4H EQU 0x029
	R5L EQU 0x02A
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R3HL EQU 0x026
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	R3HL2HL EQU 0x024
	LONG_0 EQU 0x02B
	LONG_1 EQU 0x02C
	LONG_2 EQU 0x02D
	LONG_3 EQU 0x02E
	LONG2_0 EQU 0x02F
	LONG2_1 EQU 0x030
	LONG2_2 EQU 0x031
	LONG2_3 EQU 0x032
	LONG1 EQU 0x02B
	LONG2 EQU 0x02F
	REGSTEP EQU 0x033
;       The address of 'step_duration' (word) (global) is 0x035
;       The address of 'command' (byte) (global) is 0x034
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0003
	ORG 0x0004
	RETFIE
; User code start
L0003:
; 1: Define CONFIG = 0x33c4
; 2: 
; 3: 
; 4: 'program GCA202
; 5: 'program is for monophase stepper motors (5 connections )
; 6: 'mainly issued for use with steppermotor 28BYJ-48
; 7: 
; 8: Define STEP_A_REG = PORTA
; 9: Define STEP_A_BIT = 1
; 10: Define STEP_B_REG = PORTA
; 11: Define STEP_B_BIT = 2
; 12: Define STEP_C_REG = PORTC
; 13: Define STEP_C_BIT = 0
; 14: Define STEP_D_REG = PORTC
; 15: Define STEP_D_BIT = 1
; 16: Define STEP_MODE = 1
; 17: TRISA = %111001
	MOVLW 0x39
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 18: TRISC = %100100
	MOVLW 0x24
	BSF STATUS,RP0
	MOVWF TRISC
	BCF STATUS,RP0
; 19: PORTA = 0
	CLRF PORTA
; 20: PORTC = 0
	CLRF PORTC
; 21: AllDigital
	BSF STATUS,RP0
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON0
; 22: ANSEL = %00000001
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF ANSEL
	BCF STATUS,RP0
; 23: StepHold
	BSF PORTA,1
	BSF PORTA,2
	BCF PORTC,0
	BCF PORTC,1
	BSF STATUS,RP0
	BCF TRISA,1
	BCF TRISA,2
	BCF TRISC,0
	BCF TRISC,1
	BCF STATUS,RP0
	CLRF REGSTEP
; 24: Dim step_duration As Word  'this is interval between steps.
; 25: Dim command As Byte  'used for calculating forward or reverse.
; 26: 
; 27: main:
L0001:
; 28: Gosub get_speed
	CALL L0002
; 29: command = 3
	MOVLW 0x03
	MOVWF 0x034
; 30: command.0 = RA5
	BCF 0x034,0
	BTFSC PORTA,5
	BSF 0x034,0
; 31: command.1 = RA4
	BCF 0x034,1
	BTFSC PORTA,4
	BSF 0x034,1
; 32: Select Case command
; 33: Case 0, 2
	MOVF 0x034,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0006
	GOTO L0005
L0006:
	MOVF 0x034,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0004
L0005:
; 34: StepCW 1, step_duration
	MOVLW 0x01
	MOVWF R5L
	MOVF R5L,F
	BTFSC STATUS,Z
	GOTO L0008
L0007:
	CALL ST01
	MOVF 0x035,W
	MOVWF R4L
	MOVF 0x036,W
	MOVWF R4H
	CALL Y001
	DECFSZ R5L,F
	GOTO L0007
L0008:
; 35: RC3 = 1
	BSF PORTC,3
; 36: RC4 = 0
	BCF PORTC,4
; 37: Case 1
	GOTO L0009
L0004:
	MOVF 0x034,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0010
; 38: StepCCW 1, step_duration
	MOVLW 0x01
	MOVWF R5L
	MOVF R5L,F
	BTFSC STATUS,Z
	GOTO L0012
L0011:
	CALL ST02
	MOVF 0x035,W
	MOVWF R4L
	MOVF 0x036,W
	MOVWF R4H
	CALL Y001
	DECFSZ R5L,F
	GOTO L0011
L0012:
; 39: RC3 = 0
	BCF PORTC,3
; 40: RC4 = 1
	BSF PORTC,4
; 41: Case Else  'clear all outputs, motor off, no current through coils.
	GOTO L0013
L0010:
; 42: RA1 = 0
	BCF PORTA,1
; 43: RA2 = 0
	BCF PORTA,2
; 44: RC0 = 0
	BCF PORTC,0
; 45: RC1 = 0
	BCF PORTC,1
; 46: RC3 = 0
	BCF PORTC,3
; 47: RC4 = 0
	BCF PORTC,4
; 48: EndSelect
L0013:
L0009:
; 49: Goto main
	GOTO L0001
; 50: End
L0014:	GOTO L0014
; 51: get_speed:
L0002:
; 52: Adcin 0, step_duration
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	MOVWF ADCON1
	BCF STATUS,RP0
	CLRF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x035
	MOVF ADRESH,W
	MOVWF 0x036
; 53: step_duration = step_duration * 62  '0..1023 > 0..63426
	MOVF 0x035,W
	MOVWF R3L
	MOVF 0x036,W
	MOVWF R3H
	MOVLW 0x3E
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVF R2L,W
	MOVWF 0x035
	MOVF R2H,W
	MOVWF 0x036
; 54: step_duration = step_duration + 1500  'limited between 1500 and 64926
	MOVF 0x035,W
	ADDLW 0xDC
	MOVWF 0x035
	MOVF 0x036,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x05
	MOVWF 0x036
; 55: 
; 56: Return
	RETURN
; End of user code
L0015:	GOTO L0015
;
;
; Delay Routine Byte
; minimal routine execution time: 4s
; routine execution time step: 1.5s
; maximal routine execution time: 385s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 7.5s
; routine execution time step: 5s
; maximal routine execution time: 327682.5s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitus Routine Word
; minimal routine execution time: 7.5s
; routine execution time step: 5s
Y001:	MOVLW 0x08
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
Y002:	MOVLW 0x05
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
;
;
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x0B
	MOVWF R4L
	CALL DL01
	BSF ADCON0,GO
A002:
	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; Stepper Routine
ST01:	INCF REGSTEP,F
	GOTO ST03
ST02:	DECF REGSTEP,F
ST03:
	BTFSC REGSTEP,1
	GOTO ST04
	BTFSC REGSTEP,0
	GOTO ST21
	GOTO ST20
ST04:
	BTFSC REGSTEP,0
	GOTO ST23
	GOTO ST22
ST20:
	BSF PORTA,1
	BSF PORTA,2
	BCF PORTC,0
	BCF PORTC,1
	RETURN
ST21:
	BCF PORTA,1
	BSF PORTA,2
	BSF PORTC,0
	BCF PORTC,1
	RETURN
ST22:
	BCF PORTA,1
	BCF PORTA,2
	BSF PORTC,0
	BSF PORTC,1
	RETURN
ST23:
	BSF PORTA,1
	BCF PORTA,2
	BCF PORTC,0
	BSF PORTC,1
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x33C4
; End of listing
	END
