/*
Giling Computer Applications
CAN-GC2 box
*/
$fn=100;
support_high = 4;
walls = 2;
BOX=1;
LID = 1;
COMP=1;

x_size = 91.5+2*walls+2;
y_size =41.9+2*walls+2;
if (LID)
{
    translate([0,-70,0])
    {
        difference()
        {
            translate([-walls,-walls,0]) cube([x_size,y_size,7]);
            translate([0,0,walls]) cube([93.5,43.9,22]);
            translate([15,1.3,0]) cube([27.5,6.2,4]); // opening for J3
            translate([15,.5,0]) cube([2,2,4]);
            translate([40.5,.5,0]) cube([2,2,4]);
            
            translate([47,1.3,0]) cube([27.5,6.2,4]);//opening for J4
            translate([47,.5,0]) cube([2,2,4]);
            translate([72.5,.5,0]) cube([2,2,4]);
            
            translate([74,12.3,0]) cylinder(3,1.6,1.6);// hole for L2
            translate([69,12.3,0]) cylinder(3,1.6,1.6);// hole for L3
            translate([12.9,y_size-2*walls,2]) cube([31.5,5,13]);//opening for J1 
            translate([49,y_size-2*walls,2]) cube([31.5,5,13]); //opening for J2
            translate ([-2,22,5.5]) cube([walls,6,2]);// opening to get lid off
            translate([31,12,0]) linear_extrude(0.5) mirror([1,0,0]) text("9-16",3,halign="center",valign="center");            
            translate([60,12,0]) linear_extrude(0.5) mirror([1,0,0]) text("1-8",3,halign="center",valign="center");

            if(COMP)
            {  
                translate([48.2,25,0]) linear_extrude(0.5) mirror([1,0,0]) text("GCA",5,halign="center",valign="center");
            }
            translate([48.2,35,0]) linear_extrude(0.5)  mirror([1,0,0]) text("CAN-GC2",5,halign="center",valign="center");
        }
        translate([walls,41.9,0]) cube([10,2,9]);
        translate([walls,42.8,8]) rotate ([45,0,0]) cube([10,2,1.5]);
        translate([82,41.9,0]) cube([10,2,9]);
        translate([82,42.8,8]) rotate ([45,0,0]) cube([10,2,1.5]);
        translate([82,-.1,0]) cube([10,2,9]);
        translate([82,1,8]) rotate ([45,0,0]) cube([10,1.5,2]);
        translate([walls,-.1,0]) cube([10,2,9]);
        translate([walls,1,8]) rotate ([45,0,0]) cube([10,1.5,2]);
    }    
}
if (BOX)
{
    translate([0,0,0])
    {
        difference()
        {
            translate([-walls,-walls,0]) cube([x_size,y_size,15]);
            translate([0,0,walls]) cube([93.5,y_size-2*walls,13]);
            translate([walls,-1,10]) cube([10,1,3]);
            translate([82,-1,10]) cube([10,1,3]); 
            translate([walls,43.9,10]) cube([10,1,3]);
            translate([82,43.9,10]) cube([10,1,3]);
            translate([12.9,-walls,7]) cube([32,5,13]); //opening for J1
            translate([49.6,-walls,7]) cube([32,5,13]); //opening for J2
         //   translate([46.72,-2,11.6]) rotate([-90,0,0]) cylinder(7,1.5,1.5);
            translate([walls-2,0,walls]) cube([13,2,13]);
            translate([80.5,0,walls]) cube([13,2,13]);
            translate([8, 4.2, 0]) cylinder(support_high + walls, 2.1, 2.1);
            translate([85.5, 37.2, 0]) cylinder(support_high + walls, 2.1, 2.1);
          

        }
        
        difference()//outside mounting left
        {
            translate([-6,y_size/2-4,0]) cube ([10,8,3]);
            translate([-6,y_size/2,0]) cylinder(3,1.8,1.8);
        }
        difference()//outside mounting left
        {
            translate([-6,y_size/2,0]) cylinder (3,4,4);
            translate([-6,y_size/2,0]) cylinder(3,1.8,1.8);
        }
        difference()//outside mounting right
        {
            translate([x_size-8,y_size/2-4,0]) cube ([10,8,3]);
            translate([x_size+3,y_size/2,0]) cylinder(3,1.8,1.8);
        }
        difference()//outside mounting right
        {
            translate([x_size+3,y_size/2,0]) cylinder (3,4,4);
            translate([x_size+3,y_size/2,0]) cylinder(3,1.8,1.8);
        }
        difference() // standoff bottom left
        {
            translate([8, 4.2, walls]) cylinder(support_high,4,4);
            translate([8, 4.2, 0]) cylinder(support_high + support_high, 2.1, 2.1);
        }
         // standoff top left 
        translate([8.4, 37.2, walls]) cylinder(support_high,4,4);
        translate([8.4, 37.2, support_high + walls]) cylinder(2.5, 1.9, 1.9);
        
        difference() //standoff top right
        {
            translate([85.5, 37.2, walls]) cylinder(support_high,4,4);
            translate([85.5, 37.2, 0]) cylinder(support_high + walls, 2.1, 2.1);
        }
        // standoff bottom right
        translate([85.5 ,4.2, walls]) cylinder(support_high, 4, 4);
        translate([85.5 ,4.2, support_high + walls]) cylinder(2.5, 1.9, 1.9);
        
     }
}

